USE [MonitorDB]
GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE name = 'Check_Remote_Servers' and type = 'P')
EXEC ('CREATE PROC [dbo].[Check_Remote_Servers] AS PRINT ''STUB VERSION'' ')
GO

ALTER PROC [dbo].[Check_Remote_Servers]
   @proc        SYSNAME
 , @par1        VARCHAR(50) = '' 
 , @par2        VARCHAR(50) = '' 
 , @par3        VARCHAR(50) = '' 
 , @par4        VARCHAR(50) = '' 
AS

/* Execute a stored procedure against all linked servers defined on this server.
** Params: @proc        = name of stored procedure to be executed
**         @par1/2/3/4  = name and content of parameter(s) to be supplied to @proc
** Example: EXEC Check_Remote_Servers @proc = 'Check_Backups', @par1 = '@days_back=14'
** This will execute the procedure 'Check_Backups' against all linked servers with the parameter '@days_back' set to '14' instead of the default value '7'
*/

SET NOCOUNT ON
DECLARE   @server_name SYSNAME
        , @cmd         NVARCHAR(MAX) 
DECLARE   @linked_servers TABLE ([server_name] SYSNAME)
INSERT    @linked_servers
  SELECT  name 
  FROM    master.sys.servers 

SELECT   @server_name = MIN([server_name]) FROM @linked_servers
WHILE @server_name IS NOT NULL
  BEGIN
    PRINT 'Starting proc ''' + @proc + ''' on server ''' + @server_name + ''''
    SET @cmd = 'EXEC [' + @proc + '] @Server_Name = [' + @server_name + '] ' 
                  + CASE WHEN @par1 != '' THEN ', '+ @par1   ELSE '' END
                  + CASE WHEN @par2 != '' THEN ', '+ @par2   ELSE '' END
                  + CASE WHEN @par3 != '' THEN ', '+ @par3   ELSE '' END
                  + CASE WHEN @par4 != '' THEN ', '+ @par4   ELSE '' END    
    EXEC sp_executesql @cmd                   
    DELETE @linked_servers WHERE [server_name] = @server_name
    SELECT  @server_name = MIN([server_name]) FROM @linked_servers
  END


GO