# ---------------------------------------------------------------------------
### <Script>
### <Author>
### Chad Miller 
### </Author>
### <Description>
### Writes information from backupset table to the specified table
### </Description>
### <Usage>
### backupAnalysis.ps1
### </Usage>
### </Script>
# ---------------------------------------------------------------------------


$destServer = 'Z002\SQLEXPRESS'
$destdb = 'backupdw'

#######################
function Get-SqlData
{
    param([string]$serverName=$(throw 'serverName is required.'), [string]$databaseName=$(throw 'databaseName is required.'),
          [string]$query=$(throw 'query is required.'))

    Write-Verbose "Get-SqlData serverName:$serverName databaseName:$databaseName query:$query"

    $connString = "Server=$serverName;Database=$databaseName;Integrated Security=SSPI;"
    $da = New-Object "System.Data.SqlClient.SqlDataAdapter" ($query,$connString)
    $dt = New-Object "System.Data.DataTable"
    $da.fill($dt) > $null
    $dt

} #Get-SqlData

#######################
function Get-BackupSet
{
    param($srcServer,$backup_set_id)

$qry = @"
SELECT @@servername, backup_set_id, database_name, backup_start_date, backup_finish_date, user_name,type
FROM backupset
WHERE type IN ('D','I')
AND backup_start_date > '2008-01-01'
AND backup_set_id > $backup_set_id
"@
    Get-SqlData $srcServer 'msdb' $qry

}# Get-BackupSet

#######################
function Write-DataTableToDatabase
{ 
    param ($dataTable,$destTbl)

    $connectionString = "Data Source=$destServer;Integrated Security=true;Initial Catalog=$destdb;"
    $bulkCopy = new-object ("Data.SqlClient.SqlBulkCopy") $connectionString
    $bulkCopy.DestinationTableName = "$destTbl"
    $bulkCopy.WriteToServer($dataTable)

}# Write-DataTableToDatabase

#######################
## MAIN             ##
#######################

Get-SqlData $destServer $destDb  "SELECT * FROM server_dim" |
foreach {$dataTable = Get-BackupSet $_.server_name  $_.max_backup_set_id; if ($dataTable) { Write-DataTableToDatabase $dataTable 'backupset_dim'} }
