/*
Samuel Vanga
04/10/2015
Setup.sql creates a new database, SSISPatterns with a staging table in it.
Used for article "SSIS Design Pattern - Staging Flat Files"
*/

USE master;
GO
IF EXISTS ( SELECT  *
            FROM    sys.sysdatabases AS s
            WHERE   s.name = 'SSISPatterns' )
    PRINT 'Database SSISPatterns already exists.';
ELSE
    BEGIN
        PRINT 'Creating SSISPatterns Database...';
        CREATE DATABASE SSISPatterns;
        PRINT 'Database SSISPatterns created successfuly.';
    END;
GO
USE SSISPatterns;
GO
IF EXISTS ( SELECT  *
            FROM    sys.tables AS t
            WHERE   t.name = 'stgMyDelimFile' )
    DROP TABLE dbo.stgMyDelimFile;
GO
CREATE TABLE dbo.stgMyDelimFile
    (
      Region VARCHAR(50) ,
      CYear INT ,
      Sales INT
    );