USE [CALM_STAGE]
GO

IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'metadata.[Run_SQL]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE metadata.[Run_SQL]
	print '-----------------------------------------------------------------'
	print 'DROPPED STORED PROC || ' + 'metadata.[Run_SQL]'
END
GO
------------------------------------------------------------------------------
create PROCEDURE metadata.[Run_SQL]
(
	@p_Scripts_Folder_Path	VARCHAR(255)	= '' /* 'C:\TestSQLScripts'*/
	,@p_DB_Connection_String VARCHAR(255) = '' /* YOUR_SERVER;Initial Catalog=YOUR_DATABASE;Provider=SQLNCLI11.1;Integrated Security=SSPI;' */
)
AS
BEGIN
	/********************************************************
	* Purpose: execute Run_SQL_Scripts SSIS project from the server
	* Preconditions:
	* 1. Run_SQL_Scripts folder should be created under SSISDB--> Integration Services Catalogs
	* 2. project has to be deployed in the above folder; project related tables & logging stored procs are to be in place.
	* 3. @p_Scripts_Folder_Path --> the folder should be accessible 
	*    by the user running this stored proc. (i.e. this proc should be executed under Active Directory account, not  under sql server account)
	!!This has to be verified and confirmed!!

	********************************************************/
	SET NOCOUNT ON
	BEGIN TRY
		DECLARE 
			@INT_PROCESS_ID INT = (SELECT INT_PROCESS_ID  FROM METADATA.PROCESS WHERE PROCESS_NAME = 'RUN_SQL'),
			@DB_ConnectionString	NVARCHAR(255)   = @p_DB_Connection_String,
			@Scripts_Folder_Path				NVARCHAR(255) = @p_Scripts_Folder_Path,
			@sErrorMsg						VARCHAR(1000) = ''

---------------------------------
-- Validation
-----------------------------------
		  IF EXISTS 
		  (
			SELECT 1 
			FROM 
				SSISDB.CATALOG.EXECUTIONS 
			WHERE 
				package_name = 'PKG_Execute_SQL_Scripts.dtsx'
			AND [STATUS] = 2
		)
		BEGIN
				SET @sErrorMsg  = 'Execute SQL Scripts process is running already!' +' || EXITING...';
				THROW 50001, @sErrorMsg, 1;
		END

		IF (COALESCE(@Scripts_Folder_Path,'') = '') 
		BEGIN
			SET @sErrorMsg  = '@Scripts_Folder_Path' +' || PARAMETER IS NOT SET. EXITING...';
			THROW 50001, @sErrorMsg, 1;
		END
----------------------------------------------
-- Submit 

		DECLARE @execution_id BIGINT
		EXEC [SSISDB].[catalog].[create_execution] 
				@package_name=N'PKG_Execute_SQL_Scripts.dtsx', 
				@execution_id=@execution_id OUTPUT, 
				@folder_name=N'Run_SQL_Scripts', 
				@project_name=N'Run_SQL_Scripts',
				@use32bitruntime=False, 
				@reference_id=Null

		SELECT execution_id = @execution_id

		EXEC [SSISDB].[catalog].[set_execution_parameter_value] 
			@execution_id,  
			@object_type=20, --> (20 is for project parameter, 30 is a package parameter)
			@parameter_name=N'PROCESS_ID', 
			@parameter_value=@INT_PROCESS_ID

		EXEC [SSISDB].[catalog].[set_execution_parameter_value] 
			@execution_id,  
			@object_type=20, --> (20 is for project parameter, 30 is a package parameter)
			@parameter_name=N'DB_ConnectionString', 
			@parameter_value=@DB_ConnectionString

		EXEC [SSISDB].[catalog].[set_execution_parameter_value] 
			@execution_id,  
			@object_type=20, --> (20 is for project parameter, 30 is a package parameter)
			@parameter_name=N'ScriptsFolderPath', 
			@parameter_value=@Scripts_Folder_Path

		EXEC [SSISDB].[catalog].[start_execution] @execution_id
		PRINT 'STARTED EXECUTION'

	END TRY
	BEGIN CATCH
		THROW
	END CATCH
END
go
-------------------------------------------------------------------------------------------------------
 IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'metadata.[Run_SQL]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
	print '-----------------------------------------------------------------'
	print 'CREATED STORED PROC || ' + 'metadata.[Run_SQL]'
END 
go