/*
CREATE 5 stored procs for logging:
	[metadata].[LogProcessStart] --> SSIS project level logging
	[metadata].[LogProcessEnd]	 --> SSIS project level logging
	[metadata].[LogPackageStart] --> package level logging
	[metadata].[LogPackageEnd]	 --> package level logging
	[metadata].[LogPackageError] --> error (if any) logging

 Author:    Daniel Klionsky: 07/07/2017
*/

USE [CALM_STAGE_ARCHIVE]
GO

IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[metadata].[LogProcessStart]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [metadata].[LogProcessStart]
	print '-----------------------------------------------------------------'
	print 'DROPPED STORED PROC || ' + '[metadata].[LogProcessStart]'
END
GO
------------------------------------------------------------------------------
CREATE PROCEDURE [metadata].[LogProcessStart](
	 @p_PROCESS_ID BIGINT = 1
	,@p_DATA_SOURCE_SUBSYSTEM_STR VARCHAR(255) = '0'
    ,@p_AS_OF_DATE date ='1/1/2015'
	,@p_IS_FULL_LOAD bit = 0
	,@p_ETL_STEPS varchar(3)='ETL'
	,@p_DATA_TIME_FRAME VARCHAR(1) ='M'
	,@p_EXECUTED_BY VARCHAR(64) = NULL

)
AS
/********************************************************
*
* Purpose:  Log Process start in db. 
* Called From : ETL job
*
* Author:    Daniel Klionsky: 07/07/2017
********************************************************/ 
BEGIN
	SET NOCOUNT ON;
DECLARE 
 @INT_PROCESS_LOG_ID BIGINT 
,@PROCESS_NAME VARCHAR(255) = (
								SELECT PROCESS_NAME 
								FROM METADATA.PROCESS P
								WHERE P.INT_PROCESS_ID = @p_PROCESS_ID
								)
,@status_msg VARCHAR(500)
SET @status_msg='STARTED ||  ' + QUOTENAME(OBJECT_SCHEMA_NAME(@@PROCID))+'.'+QUOTENAME(OBJECT_NAME(@@PROCID))

BEGIN TRY

INSERT INTO METADATA.PROCESS_LOG(
 INT_PROCESS_ID
,[START_DATE]
,[DESCR]
,[PARAM_STRING]
,EXECUTED_BY
)
SELECT 
INT_PROCESS_ID = @p_PROCESS_ID
,[START_DATE] = GETDATE()
,[DESCR] = @PROCESS_NAME 
,PARAM_STRING= 'SUB_SYSTEM_STR : ''' + @p_DATA_SOURCE_SUBSYSTEM_STR + ''''
    + ', AS_OF_DATE : ''' + CONVERT(VARCHAR(20),@p_AS_OF_DATE) +''''
    + ', IS_FULL_LOAD : ''' + CONVERT(VARCHAR(20),@p_IS_FULL_LOAD) +''''
    + ', ETL_STEPS : ''' + @p_ETL_STEPS +''''
    + ', DATA_TIME_FRAME : ''' + @p_DATA_TIME_FRAME +''''
,@p_EXECUTED_BY
SELECT  @INT_PROCESS_LOG_ID= SCOPE_IDENTITY()

-- RETURN RESULT:	
SELECT @INT_PROCESS_LOG_ID

END TRY
BEGIN CATCH
	THROW
END CATCH;

END

go
-------------------------------------------------------------------------------------------------------
 IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[metadata].[LogProcessStart]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
	print '-----------------------------------------------------------------'
	print 'CREATED STORED PROC || ' + '[metadata].[LogProcessStart]'
END 
go
------------------------------------------------------------------------------
IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[metadata].[LogProcessEnd]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [metadata].[LogProcessEnd]
	print '-----------------------------------------------------------------'
	print 'DROPPED STORED PROC || ' + '[metadata].[LogProcessEnd]'
END
GO
create PROCEDURE [metadata].[LogProcessEnd](
@p_PROCESS_LOG_ID BIGINT = 1
)
AS
/********************************************************
*
* Purpose:  Log Package end in db. 
* Called From : ETL job
*
* Author:    Daniel Klionsky: 07/07/2017
*
********************************************************/ 
BEGIN
	SET NOCOUNT ON;
DECLARE 
@status_msg VARCHAR(500)
SET @status_msg='STARTED ||  ' + QUOTENAME(OBJECT_SCHEMA_NAME(@@PROCID))+'.'+QUOTENAME(OBJECT_NAME(@@PROCID))

BEGIN TRY

UPDATE METADATA.PROCESS_LOG
SET  END_DATE = GETDATE()
	,IS_SUCCESS = 1
WHERE 	INT_PROCESS_LOG_ID = @p_PROCESS_LOG_ID

END TRY
BEGIN CATCH
    SELECT 
        ERROR_PROCEDURE() as ErrorProcedure,
        ERROR_MESSAGE() AS ErrorMessage;
END CATCH;

SET @status_msg='FINISHED ||  ' + QUOTENAME(OBJECT_SCHEMA_NAME(@@PROCID))+'.'+QUOTENAME(OBJECT_NAME(@@PROCID))

END
go
-------------------------------------------------------------------------------------------------------
 IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[metadata].[LogProcessEnd]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
	print '-----------------------------------------------------------------'
	print 'CREATED STORED PROC || ' + '[metadata].[LogProcessEnd]'
END 
go
-----------------------------------------------------
-----------------------------------------------------------------------------------
IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[metadata].[LogPackageStart]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [metadata].[LogPackageStart]
	print '-----------------------------------------------------------------'
	print 'DROPPED STORED PROC || ' + '[metadata].[LogPackageStart]'
END
GO
------------------------------------------------------------------------------
CREATE PROCEDURE [metadata].[LogPackageStart](
 @p_PACKAGE_NAME VARCHAR(255) 
,@p_PROCESS_LOG_ID BIGINT 
)
AS
/********************************************************
*
* Purpose:  Log Package start in db. 
* Called From : ETL job
*
* Author:    Daniel Klionsky: 07/07/2017
*
* Modified:
*
********************************************************/ 
BEGIN
	SET NOCOUNT ON;
DECLARE 
 @INT_PACKAGE_LOG_ID BIGINT 
,@PACKAGE_ID INT
,@PROCESS_NAME VARCHAR(255) 
,@PROCESS_ID INT

SELECT 
  @PROCESS_NAME = P.PROCESS_NAME
, @PROCESS_ID = P.INT_PROCESS_ID
FROM METADATA.PROCESS P INNER JOIN METADATA.PROCESS_LOG PL
ON PL.INT_PROCESS_ID = P.INT_PROCESS_ID
WHERE PL.INT_PROCESS_LOG_ID = @p_PROCESS_LOG_ID


INSERT INTO METADATA.PACKAGE_LOG(
 [INT_PROCESS_LOG_ID]
,[INT_PACKAGE_ID]
,[START_DATE]
,[DESCR]
)
SELECT 
[INT_PROCESS_LOG_ID] =@p_PROCESS_LOG_ID
,[INT_PACKAGE_ID]= (SELECT INT_PACKAGE_ID FROM METADATA.PACKAGE 
				WHERE PACKAGE_NAME = @p_PACKAGE_NAME +'.dtsx')
,[START_DATE] = GETDATE()
,[DESCR] = @PROCESS_NAME + ' || ' + @p_PACKAGE_NAME

SELECT @INT_PACKAGE_LOG_ID = SCOPE_IDENTITY()
----------------------------------------------

-- LOGGING:
DECLARE @ERROR_DESCRIPTION VARCHAR(4000) = '**** STARTED' + ' || PACKAGE ' + @p_PACKAGE_NAME + '.dtsx'
DECLARE @TASK_NAME VARCHAR(100) = 'NONE'
EXECUTE METADATA.LogPackageError
 @INT_PACKAGE_LOG_ID  
,@p_PROCESS_LOG_ID  
,@ERROR_DESCRIPTION
,@TASK_NAME 
,@p_PACKAGE_NAME 
,@PROCESS_ID 
,0	--> NOT ERROR
------------------------------------------------------


-- RETURN RESULT:	
SELECT @INT_PACKAGE_LOG_ID


END

go
-------------------------------------------------------------------------------------------------------
 IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[metadata].[LogPackageStart]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
	print '-----------------------------------------------------------------'
	print 'CREATED STORED PROC || ' + '[metadata].[LogPackageStart]'
END 
go
---------------------------------------------------------------
IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[metadata].[LogPackageEnd]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [metadata].[LogPackageEnd]
	print '-----------------------------------------------------------------'
	print 'DROPPED STORED PROC || ' + '[metadata].[LogPackageEnd]'
END
GO
------------------------------------------------------------------------------
CREATE PROCEDURE [metadata].[LogPackageEnd](
 @p_PACKAGE_LOG_ID BIGINT 
)
AS
/********************************************************
*
* Purpose:  Log Package end in db. 
* Called From : ETL job
*
* Author:    Daniel Klionsky: 07/07/2017
*
* Modified:
*
********************************************************/ 
BEGIN
	SET NOCOUNT ON;

BEGIN TRY

UPDATE METADATA.PACKAGE_LOG
SET END_DATE = GETDATE()
, IS_SUCCESS = 1
WHERE INT_PACKAGE_LOG_ID = @p_PACKAGE_LOG_ID
--------------------------------------------
-- LOGGING:

DECLARE @PROCESS_LOG_ID BIGINT
DECLARE @PACKAGE_NAME VARCHAR(100)  

SELECT 
	 @PACKAGE_NAME = P.PACKAGE_NAME
	, @PROCESS_LOG_ID = INT_PROCESS_LOG_ID
FROM metadata.PACKAGE P INNER JOIN metadata.PACKAGE_LOG PL
ON P.INT_PACKAGE_ID = PL.INT_PACKAGE_ID
AND PL.INT_PACKAGE_LOG_ID = @p_PACKAGE_LOG_ID
		 
DECLARE @PROCESS_ID INT = 
			(SELECT INT_PROCESS_ID 
			FROM metadata.PROCESS_LOG
			WHERE INT_PROCESS_LOG_ID = @PROCESS_LOG_ID)

DECLARE @ERROR_DESCRIPTION VARCHAR(4000) = '**** FINISHED' + ' || PACKAGE ' + @PACKAGE_NAME 
DECLARE @TASK_NAME VARCHAR(100) = 'NONE'
EXECUTE METADATA.LogPackageError
 @p_PACKAGE_LOG_ID  
,@PROCESS_LOG_ID  
,@ERROR_DESCRIPTION
,@TASK_NAME 
,@PACKAGE_NAME 
,@PROCESS_ID 
,0	--> NOT ERROR
------------------------------------------------------

END TRY
BEGIN CATCH
	THROW;
END CATCH;

END
go
-------------------------------------------------------------------------------------------------------
 IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[metadata].[LogPackageEnd]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
	print '-----------------------------------------------------------------'
	print 'CREATED STORED PROC || ' + '[metadata].[LogPackageEnd]'
END 
go
-------------------------------------------------

IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[metadata].[LogPackageError]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [metadata].[LogPackageError]
	print '-----------------------------------------------------------------'
	print 'DROPPED STORED PROC || ' + '[metadata].[LogPackageError]'
END
GO
------------------------------------------------------------------------------

CREATE PROCEDURE [metadata].[LogPackageError](
 @p_PACKAGE_LOG_ID BIGINT 
,@p_PROCESS_LOG_ID BIGINT 
,@p_ERROR_DESCRIPTION VARCHAR(4000)
,@p_TASK_NAME VARCHAR(1000)
,@p_PACKAGE_NAME VARCHAR(1000)
,@p_PROCESS_ID INT
,@p_IS_ERROR  BIT
)
AS

/********************************************************
*
* Purpose:  Log Package ERROR in db. 
* Called From : ETL job
*
* Author:    Daniel Klionsky: 07/07/2017
*
* Modified:
*
********************************************************/ 
BEGIN
	SET NOCOUNT ON;

DECLARE @PROCESS_NAME VARCHAR(255) = (
				SELECT PROCESS_NAME 
				FROM METADATA.PROCESS P 
				WHERE P.INT_PROCESS_ID = @p_PROCESS_ID
				)
BEGIN TRY
----------------------------------
INSERT INTO METADATA.PACKAGE_ERROR_LOG(
 INT_PACKAGE_LOG_ID
,IS_ERROR
,ERROR_DESCR
,IS_VARIABLE
,CREATED_DATE
,TASK_NAME
,[DESCR]
)
SELECT
 INT_PACKAGE_LOG_ID	= @p_PACKAGE_LOG_ID
,IS_ERROR				= @p_IS_ERROR
,ERROR_DESCRIPTION		= @p_ERROR_DESCRIPTION
,IS_VARIABLE			= 0
,CREATED_DATE				= GETDATE()
,TASK_NAME				= @p_TASK_NAME
,[DESCR]			= @PROCESS_NAME + ' || ' + @p_PACKAGE_NAME
----------------------------------------
IF @p_IS_ERROR = 1 BEGIN 
	UPDATE METADATA.PACKAGE_LOG
	SET END_DATE = GETDATE()
	, IS_SUCCESS = 0
	WHERE INT_PACKAGE_LOG_ID = @p_PACKAGE_LOG_ID
	------------------------------------
	UPDATE METADATA.PROCESS_LOG
	SET  END_DATE = GETDATE()
		,IS_SUCCESS = 0
	WHERE 	INT_PROCESS_LOG_ID = @p_PROCESS_LOG_ID
END

END TRY
BEGIN CATCH
  THROW;
END CATCH;


END

go
-------------------------------------------------------------------------------------------------------
 IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[metadata].[LogPackageError]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
	print '-----------------------------------------------------------------'
	print 'CREATED STORED PROC || ' + '[metadata].[LogPackageError]'
END 
go
---------------------------------------------------