
/*
1. CREATE 5 tables for logging:

	[metadata].[AL_INT_PROCESS]      --> list of SSIS projects
	[metadata].[AL_INT_PACKAGE]		 --> list of packages
	[metadata].[AL_INT_PROCESS_LOG]  --> SSIS project level logging (start/end datetimes)
	[metadata].[AL_INT_PACKAGE_LOG]  --> package level logging (start/end datetimes)
	[metadata].[AL_INT_PACKAGE_ERROR_LOG] --> messages (while executing the scripts)

2. create SEED DATA FOR [metadata].[AL_INT_PROCESS] & [metadata].[AL_INT_PACKAGE] tables
3. create view [metadata].[VW_PACKAGE_ERROR_LOG] -> for easy reporting
 Author:    Daniel Klionsky: 07/07/2017

*/


USE [CALM_STAGE_ARCHIVE]
GO
if not exists (select 1 from sys.schemas where name ='metadata')
	exec ('create schema [metadata] authorization [dbo]')
go
IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.TABLES 
           WHERE TABLE_NAME = N'PROCESS' AND TABLE_SCHEMA = 'metadata' )
BEGIN
  drop table [metadata].[PROCESS];
  PRINT 'DROPPED TABLE || [metadata].[PROCESS]'
END
------------------------------------------------------------------------------
CREATE TABLE [metadata].[PROCESS](
	[INT_PROCESS_ID] [int] IDENTITY(1,1) NOT NULL,
	[PROCESS_NAME] [varchar](255) NOT NULL,
	[CREATED_BY] [varchar](30) NOT NULL DEFAULT (suser_sname()),
	[CREATED_DATE] [smalldatetime] NOT NULL DEFAULT (getdate()),
 CONSTRAINT [PROCESS_PK] PRIMARY KEY CLUSTERED ([INT_PROCESS_ID] ),
 CONSTRAINT [PROCESS_UN] UNIQUE ([PROCESS_NAME] )
) 

go
-------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.TABLES 
           WHERE TABLE_NAME = N'PROCESS' AND TABLE_SCHEMA = 'metadata' )
BEGIN
  PRINT 'CREATED TABLE || [metadata].[PROCESS]'
END
GO
-------------------------------------------------------------
IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.TABLES 
           WHERE TABLE_NAME = N'PACKAGE' AND TABLE_SCHEMA = 'metadata' )
BEGIN
  drop table [metadata].[PACKAGE];
  PRINT 'DROPPED TABLE || [metadata].[PACKAGE]'
END
------------------------------------------------------------------------------
CREATE TABLE [metadata].[PACKAGE](
	[INT_PACKAGE_ID] [int] IDENTITY(1,1) NOT NULL,
	[PACKAGE_NAME] [varchar](255) NOT NULL,
	[CREATED_BY] [varchar](30) NULL DEFAULT (suser_sname()),
	[CREATED_DATE] [smalldatetime] NULL DEFAULT (getdate()),
 CONSTRAINT [PACKAGE_PK] PRIMARY KEY CLUSTERED ([INT_PACKAGE_ID] ),
 CONSTRAINT [PACKAGE_UN] UNIQUE ([PACKAGE_NAME])
)
GO
-------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.TABLES 
           WHERE TABLE_NAME = N'PACKAGE' AND TABLE_SCHEMA = 'metadata' )
BEGIN
  PRINT 'CREATED TABLE || [metadata].[PACKAGE]'
END
---------------------------------------------------------
go
IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.TABLES 
           WHERE TABLE_NAME = N'PROCESS_LOG' AND TABLE_SCHEMA = 'metadata' )
BEGIN
  drop table [metadata].[PROCESS_LOG];
  PRINT 'DROPPED TABLE || [metadata].[PROCESS_LOG]'
END
------------------------------------------------------------------------------
CREATE TABLE [metadata].[PROCESS_LOG](
	[INT_PROCESS_LOG_ID] [bigint] IDENTITY(1,1) NOT NULL,
	[INT_PROCESS_ID] [int] NOT NULL,
	[PARAM_STRING] [varchar](255) NULL,
	[START_DATE] [smalldatetime] NULL,
	[END_DATE] [smalldatetime] NULL,
	[IS_SUCCESS] [varchar](1) NULL,
	[DESCR] [varchar](1000) NULL,
	[EXECUTED_BY] [varchar](64) NULL,
 CONSTRAINT [PROCESS_LOG_PK] PRIMARY KEY CLUSTERED ([INT_PROCESS_LOG_ID] ));

ALTER TABLE [metadata].[PROCESS_LOG]  WITH CHECK ADD  CONSTRAINT [PROCESS_LOG_FK1] FOREIGN KEY([INT_PROCESS_ID])
REFERENCES [metadata].[PROCESS] ([INT_PROCESS_ID]);
ALTER TABLE [metadata].[PROCESS_LOG] CHECK CONSTRAINT [PROCESS_LOG_FK1];
go
-------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.TABLES 
           WHERE TABLE_NAME = N'PROCESS_LOG' AND TABLE_SCHEMA = 'metadata' )
BEGIN
  PRINT 'CREATED TABLE || [metadata].[PROCESS_LOG]'
END
GO
-------------------------------
go
IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.TABLES 
           WHERE TABLE_NAME = N'PACKAGE_LOG' AND TABLE_SCHEMA = 'metadata' )
BEGIN
  drop table [metadata].[PACKAGE_LOG];
  PRINT 'DROPPED TABLE || [metadata].[PACKAGE_LOG]'
END
------------------------------------------------------------------------------
CREATE TABLE [metadata].[PACKAGE_LOG](
	[INT_PACKAGE_LOG_ID] [bigint] IDENTITY(1,1) NOT NULL,
	[INT_PROCESS_LOG_ID] [bigint] NOT NULL,
	[INT_PACKAGE_ID] [int] NOT NULL,
	[START_DATE] [smalldatetime] NOT NULL,
	[END_DATE] [smalldatetime] NULL,
	[IS_SUCCESS] [varchar](1) NULL,
	[DESCR] [varchar](1000) NULL,
 CONSTRAINT [PACKAGE_LOG_PK] PRIMARY KEY CLUSTERED ([INT_PACKAGE_LOG_ID] )) 

GO

ALTER TABLE [metadata].[PACKAGE_LOG]  WITH CHECK ADD  CONSTRAINT [PACKAGE_LOG_FK1] FOREIGN KEY([INT_PROCESS_LOG_ID])
REFERENCES [metadata].[PROCESS_LOG] ([INT_PROCESS_LOG_ID])
GO

ALTER TABLE [metadata].[PACKAGE_LOG] CHECK CONSTRAINT [PACKAGE_LOG_FK1]
GO

ALTER TABLE [metadata].[PACKAGE_LOG]  WITH NOCHECK ADD  CONSTRAINT [PACKAGE_LOG_FK2] FOREIGN KEY([INT_PACKAGE_ID])
REFERENCES [metadata].[PACKAGE] ([INT_PACKAGE_ID])
GO

ALTER TABLE [metadata].[PACKAGE_LOG] CHECK CONSTRAINT [PACKAGE_LOG_FK2]
go
-------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.TABLES 
           WHERE TABLE_NAME = N'PACKAGE_LOG' AND TABLE_SCHEMA = 'metadata' )
BEGIN
  PRINT 'CREATED TABLE || [metadata].[PACKAGE_LOG]'
END
go
IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.TABLES 
           WHERE TABLE_NAME = N'PACKAGE_ERROR_LOG' AND TABLE_SCHEMA = 'metadata' )
BEGIN
  drop table [metadata].[PACKAGE_ERROR_LOG];
  PRINT 'DROPPED TABLE || [metadata].[PACKAGE_ERROR_LOG]'
END
------------------------------------------------------------------------------
CREATE TABLE [metadata].[PACKAGE_ERROR_LOG](
	[INT_PACKAGE_ERROR_LOG_ID] [bigint] IDENTITY(1,1) NOT NULL,
	[INT_PACKAGE_LOG_ID] [bigint] NOT NULL,
	[IS_ERROR] [varchar](1) NOT NULL DEFAULT ('0'),
	[ERROR_DESCR] [varchar](4000) NULL,
	[IS_VARIABLE] [varchar](1) NOT NULL DEFAULT ('0'),
	[VARIABLE_NAME] [varchar](255) NULL,
	[VARIABLE_VALUE] [varchar](4000) NULL,
	[TASK_NAME] [varchar](1000) NULL,
	[DESCR] [varchar](1000) NULL,
	[CREATED_DATE] [smalldatetime] NULL DEFAULT (getdate()),
	[CREATED_BY] [varchar](32) NULL DEFAULT (suser_sname()),
 CONSTRAINT [PACKAGE_ERROR_LOG_PK] PRIMARY KEY CLUSTERED ([INT_PACKAGE_ERROR_LOG_ID] )) 

GO

ALTER TABLE [metadata].[PACKAGE_ERROR_LOG]  WITH CHECK ADD  CONSTRAINT [PACKAGE_ERROR_LOG_FK] FOREIGN KEY([INT_PACKAGE_LOG_ID])
REFERENCES [metadata].[PACKAGE_LOG] ([INT_PACKAGE_LOG_ID])
GO

ALTER TABLE [metadata].[PACKAGE_ERROR_LOG] CHECK CONSTRAINT [PACKAGE_ERROR_LOG_FK]
GO
go
-------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.TABLES 
           WHERE TABLE_NAME = N'PACKAGE_ERROR_LOG' AND TABLE_SCHEMA = 'metadata' )
BEGIN
  PRINT 'CREATED TABLE || [metadata].[PACKAGE_ERROR_LOG]'
END
GO
------------------------------------------------

-- create SEED DATA FOR [metadata].[AL_INT_PROCESS] & [metadata].[AL_INT_PACKAGE] tables:

IF NOT EXISTS (SELECT 1 FROM [metadata].[PROCESS] WHERE [PROCESS_NAME] ='RUN_SQL') BEGIN
	INSERT INTO [metadata].[PROCESS] ([PROCESS_NAME]) SELECT 'RUN_SQL';
	PRINT 'Table [metadata].[PROCESS] || ADDED A ROW '
END
IF NOT EXISTS (SELECT 1 FROM [metadata].[PACKAGE] WHERE [PACKAGE_NAME] = 'PKG_Execute_SQL_Scripts.dtsx') BEGIN
	INSERT INTO [metadata].[PACKAGE]([PACKAGE_NAME]) SELECT 'PKG_Execute_SQL_Scripts.dtsx';
		PRINT 'Table [metadata].[PACKAGE] || ADDED A ROW '
END
go
------
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.Views 
           WHERE TABLE_NAME = 'VW_PACKAGE_ERROR_LOG' AND TABLE_SCHEMA = 'metadata' )
BEGIN
  DROP VIEW [metadata].[VW_PACKAGE_ERROR_LOG];
  PRINT 'DROPPED VIEW || [metadata].[VW_PACKAGE_ERROR_LOG]'
END
GO


CREATE view [metadata].[VW_PACKAGE_ERROR_LOG]
  AS
/*
--- DISPLAY DURATION BY Converting seconds into HH:MM:SS format
-- http://stackoverflow.com/questions/14116821/converting-seconds-into-hhmmss-format

*/
WITH CTE(INT_PACKAGE_ERROR_LOG_ID, DURATION_IN_SEC)
AS
(
SELECT 	INT_PACKAGE_ERROR_LOG_ID
, DATEDIFF(SECOND, 
		  (	SELECT PEL.[CREATED_DATE] 
			FROM [METADATA].PACKAGE_ERROR_LOG PEL
			WHERE 
			PEL.[INT_PACKAGE_LOG_ID] = A.[INT_PACKAGE_LOG_ID]
			AND PEL.TASK_NAME = TASK_NAME
			AND 
			PEL.ERROR_DESCR LIKE '%STARTED%'
			AND RTRIM(LTRIM(REPLACE(A.ERROR_DESCR,'FINISHED',''))) = RTRIM(LTRIM(REPLACE(PEL.ERROR_DESCR,'STARTED','')))
			),A.[CREATED_DATE])
  FROM [METADATA].[PACKAGE_ERROR_LOG] A
  WHERE A.ERROR_DESCR LIKE '%FINISHED%' 
)

SELECT ID = A.INT_PACKAGE_ERROR_LOG_ID
,[DURATION]= CASE WHEN A.ERROR_DESCR LIKE '%FINISHED%' THEN 
				replace(str(CTE.DURATION_IN_SEC/3600,len(ltrim(CTE.DURATION_IN_SEC/3600))+
				abs(sign(CTE.DURATION_IN_SEC/359999)-1)) + ':' + str((CTE.DURATION_IN_SEC/60)%60,2)+
				':' + str(CTE.DURATION_IN_SEC%60,2),' ','0')
		ELSE NULL END
    , [MESSAGE]= CASE WHEN A.[ERROR_DESCR] IS NULL AND A.[IS_VARIABLE] = 1 THEN [VARIABLE_NAME] + ' || ' + [VARIABLE_VALUE]
						ELSE A.[ERROR_DESCR] END
    ,[TYPE] = CASE WHEN A.[IS_ERROR] = 0 THEN 'INFO' ELSE 'ERROR' END
	,LOGGED_AT = FORMAT(A.[CREATED_DATE], 'hh:mm MM-dd-yyyy')
	,ACCOUNT_USED = A.CREATED_BY /* sql server internal account */
	,EXECUTED_BY = C.EXECUTED_BY /* external, i.e. logged in person */
    ,[PROCESS || PACKAGE] = A.[DESCR]
	,[PKG TASK_NAME || STORED PROC] = TASK_NAME
    ,B.[INT_PROCESS_LOG_ID]
	,[PROCESS PARAMS] = C.[PARAM_STRING]
FROM [metadata].[PACKAGE_ERROR_LOG] A
INNER JOIN [metadata].PACKAGE_LOG B ON A.[INT_PACKAGE_LOG_ID] = B.[INT_PACKAGE_LOG_ID]
INNER JOIN [metadata].PROCESS_LOG C ON B.INT_PROCESS_LOG_ID =C.INT_PROCESS_LOG_ID
LEFT JOIN CTE ON CTE.INT_PACKAGE_ERROR_LOG_ID = A.INT_PACKAGE_ERROR_LOG_ID
GO
----------------
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.Views 
           WHERE TABLE_NAME = 'VW_PACKAGE_ERROR_LOG' AND TABLE_SCHEMA = 'metadata' )
BEGIN
  PRINT 'CREATED VIEW || [metadata].[VW_PACKAGE_ERROR_LOG]'
END
GO
------------------------------------------------------------
-----------------END
------------------------------------------------------------
