USE ExportDB

IF EXISTS(SELECT * from sysobjects WHERE xtype = 'U' and name = 'TestDates')
DROP TABLE TestDates
GO

CREATE TABLE TestDates (
	FiscalStartDate datetime,
	TestDate datetime
)
GO

INSERT INTO TestDates VALUES ('1/1/1900', '12/31/2008')
INSERT INTO TestDates VALUES ('1/1/1900', '1/1/2009')
INSERT INTO TestDates VALUES ('1/1/1900', '1/2/2009')
INSERT INTO TestDates VALUES ('1/1/1900', '1/4/2009')
INSERT INTO TestDates VALUES ('1/1/1900', '1/5/2009')
INSERT INTO TestDates VALUES ('1/1/1900', '5/1/2009')
INSERT INTO TestDates VALUES ('1/1/1900', '1/1/2010')
INSERT INTO TestDates VALUES ('7/1/1900', '6/30/2009')
INSERT INTO TestDates VALUES ('7/1/1900', '7/1/2009')
INSERT INTO TestDates VALUES ('7/1/1900', '7/2/2009')
INSERT INTO TestDates VALUES ('7/1/1900', '7/6/2009')
INSERT INTO TestDates VALUES ('7/1/1900', '7/7/2009')
INSERT INTO TestDates VALUES ('7/1/1900', '12/31/2009')

SELECT 
	CONVERT(varchar,FiscalStartDate,101) AS FiscalStartDate, 
	CONVERT(varchar,TestDate,101) AS TestDate, 
	dbo.fn_445AccountingYear(FiscalStartDate, TestDate, 1) AS [445Value]
FROM TestDates

--SELECT FiscalStartDate, TestDate, Chief.dbo.fn_FiscalYear(FiscalStartDate, TestDate, TestDate, 'DateOccurrence')
--FROM TestDates


