Use SSISDB
go

print 'Custom Schema'
If Not Exists(Select s.name
              From sys.schemas s
			  Where s.name = 'custom')
 begin
  print ' - Creating custom schema'
  declare @sql varchar(50) = 'Create Schema custom'
  exec(@sql)
  print ' - Custom schema created'
 end
Else
 print ' - Custom schema already exists.'
print ''

print 'Custom.execute_catalog_package stored procedure'
If Exists(Select s.name + '.' + p.name
          From sys.procedures p
		  Join sys.schemas s
		    On s.schema_id = p.schema_id
		  Where s.name = 'custom'
		    And p.name = 'execute_catalog_package')
 begin
  print ' - Dropping custom.execute_catalog_package'
  Drop Procedure custom.execute_catalog_package
  print ' - Custom.execute_catalog_package dropped'
 end

print ' - Creating custom.execute_catalog_package'
go

Create Procedure custom.execute_catalog_package
   @package_name nvarchar(260)
 , @folder_name nvarchar(128)
 , @project_name nvarchar(128)
 , @use32bitruntime bit = False
 , @reference_id bigint = NULL
 , @logging_level varchar(11) = 'Basic'
 , @synchronized bit = 1
As

 begin

  -- create an Intent-to-Execute
  declare @execution_id bigint
  exec [SSISDB].[catalog].[create_execution]
     @package_name=@package_name
   , @execution_id=@execution_id OUTPUT
   , @folder_name=@folder_name
   , @project_name=@project_name
   , @use32bitruntime=@use32bitruntime
   , @reference_id=@reference_id

  -- Decode and configure the Logging Level
  declare @var0 smallint = Case When Upper(@logging_level) = 'NONE'
                                Then 0
								When Upper(@logging_level) = 'PERFORMANCE'
                                Then 2
								When Upper(@logging_level) = 'VERBOSE'
                                Then 3
						   Else 1 -- Basic
						   End
  exec [SSISDB].[catalog].[set_execution_parameter_value]
     @execution_id
   , @object_type=50
   , @parameter_name=N'LOGGING_LEVEL'
   , @parameter_value=@var0
						 
   -- Set synchronized parameter
  Exec catalog.set_execution_parameter_value 
    @execution_id = @execution_id
  , @object_type = 50
  , @parameter_name=N'SYNCHRONIZED'
  , @parameter_value = @synchronized

  -- Start the execution
  exec [SSISDB].[catalog].[start_execution] @execution_id

  -- Return the execution_id
  Select @execution_id As execution_id

 end
go

print ' - Custom.execute_catalog_package created.'
go
