'************************************************
' 0g_exportRecord.vbs
'
'Purpose: create insert/update deployment scripts
'
'Created: 0garcia 07102009
'
'Disclaimer:
'THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
'WITH NO WARRANTIES. THIS SOFTWARE IS PROVIDED AS DEMO ONLY. 
'YOU CAN MODIFY AND USE AT YOUR OWN RISK.
'************************************************
wscript.echo "THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ''AS IS'' WITH NO WARRANTIES. THIS SOFTWARE IS PROVIDED AS DEMO ONLY. YOU CAN MODIFY AND USE AT YOUR OWN RISK." 

 Dim objServer 'As SQLDMO.SQLServer 
 Dim objDb 'As SQLDMO.DataBase 
 Dim objView 'as SQLDMO.QueryResults

 Dim serverName 'as string
 Dim database 'as string
 Dim query 'as string 
 Dim userName 'as string
 Dim password 'as string
 Dim fileName
 Dim sql 
 Dim cmd
 
 const QUERY_FROM = " from "
 const QUERY_WHERE = " where "
 const CMD_INSERT=0
 const CMD_UPDATE =1
 Dim VBCrLf, VBTab
 VBCrLf = Chr(13) & Chr(10)
 VBTab = Chr(9)

  
'DATA TYPES 
const SQLDMO_DtypeBigint =-5
const SQLDMO_DTypeBinary =-2
const SQLDMO_DTypeBit =-7

const SQLDMO_DTypeFloat4 =7
const SQLDMO_DTypeFloat8 =8
const SQLDMO_DTypeGUID =-11
const SQLDMO_DTypeImage =-4
const SQLDMO_DTypeInt1 =-6
const SQLDMO_DTypeInt2 =5
const SQLDMO_DTypeInt4 =4
const SQLDMO_DTypeMoney =3
const SQLDMO_DTypeMoney4 =3
const SQLDMO_DTypeVarBinary =-3

const SQLDMO_DtypeSQLVariant =-150
const SQLDMO_DTypeText =-1
const SQLDMO_DTypeUChar =-8
const SQLDMO_DTypeUnknown =0
const SQLDMO_DTypeUVarchar =-9
const SQLDMO_DTypeVarchar =12
const SQLDMO_DTypeChar =1
const SQLDMO_DTypeNText =-10

const SQLDMO_DTypeDateTime =-2
const SQLDMO_DTypeDateTime4 =93

if (Wscript.Arguments.count > 4) then
  'parameters  
  serverName = Wscript.Arguments(0)  'server name
  database = Wscript.Arguments(1)    ' database name
  query = Wscript.Arguments(2)       'query 
  fileName = Wscript.Arguments(3)    'local path
  cmd =Wscript.Arguments(4)          '0 or 1  
  
  'what type of script to create
  if (cmd = 1) then
    cmd = CMD_UPDATE
  else
    cmd = CMD_INSERT
  end if 
    
  call main

else
    wscript.echo "usage: 0g_exportRecord [servername] [database] [query] [filename] [command]"
end if


public function main()

 on error resume next
 
 set objServer = CreateObject("SQLDMO.SQLServer")
 
 With objServer 
   .LoginSecure = true   'false to provide username/pw 
   .QueryTimeout = 1200 
   .Connect ServerName   ',username,pw 
 End With 
 
 Set objDb = objServer.Databases(database) 
 
 if (err.number = 0) then
 
     set objView = objDB.ExecuteWithResults(query)
     
     'select the database
     'sql = " USE " & database & VBCrLf & " GO " & VBCrLf
                    
     'get the table name
     Dim tableName, ignoreCols, pKey
     tableName = GetTableName(query)     
     ignoreCols = GetColsToIgnore(tableName, pKey)
     
     if (cmd = CMD_INSERT) then
        sql = " Print 'Inserting Record - Table: " & tableName & "'" & VBCrLf
        sql = sql & " INSERT  "
     else
 	   sql = " Print 'Updating Record - Table: " & tableName & "'" &  VBCrLf
        sql = sql & " UPDATE "
     end if
     
     sql = sql & tableName & VBCrLf
          
     'now get the column names
     sql = sql & GetColumns(cmd, ignoreCols)
               
     For rows = 1 To objView.Rows
        dim params , pKeyValue
        params = sql
     
        For cols = 1 To objView.Columns
           dim value, name, sqlType
           name = "[" & objView.ColumnName(cols) & "]"           
           value = objView.GetColumnString(rows, cols)
           sqlType = objView.ColumnType(cols)          
           value = GetColumnValue(value,sqlType)  & VBCrLf       
           params = replace(params,name,value)   
           
           if (pKey = objView.ColumnName(cols)) then  
                pKeyValue = value
           end if
        Next        
        
        if (cmd = CMD_UPDATE) then
            params = params & GetWhereClause(pKey, pKeyValue)    
        else
            params = params
        end if
        
        params = params & VBCrLf
        
        call WriteToFile(fileName, params)
     Next     
     
 end if

objServer.DisConnect
set objView = nothing
set objDb = nothing
Set objServer = nothing

wscript.echo("Done: " & fileName)

end function
 

'gets the value. scapes single quotes 
public function GetColumnValue(value, sqlType)

    dim safeValue
    
    select case (sqlType)
        case SQLDMO_DTypeDateTime,SQLDMO_DTypeDateTime4, SQLDMO_DTypeBit
             safeValue = "'" & value & "'"
        case  SQLDMO_DTypeUChar,SQLDMO_DTypeUVarchar,SQLDMO_DtypeSQLVariant , SQLDMO_DTypeNText , SQLDMO_DTypeText , SQLDMO_DTypeChar , SQLDMO_DTypeVarchar , SQLDMO_DTypeUnknown   
            safeValue = "'" & Replace(value,"'","''") & "'"        
        case else
            safeValue = value          
    end select       
    
GetColumnValue=safeValue
end function


'gets the columns from the results
public function GetColumns( byval cmd, byval ignoreCols)

     dim columns, values
     
     if (cmd = CMD_INSERT) then
        columns = "("
        values = VBCrLf & " values ("
        For cols = 1 To objView.Columns
           if(Instr(1,ignoreCols,"[" &objView.ColumnName(cols) & "]",1) = 0) then
              columns = columns & objView.ColumnName(cols) & ","
              values = values & "[" & objView.ColumnName(cols) & "],"
           end if
        Next 
        columns= mid(columns,1,len(columns)-1)     
        values= mid(values,1,len(values)-1)     
        columns = columns & ")"
        values = values & ")"
     else
        columns = VBTab & " SET "
        
        For cols = 1 To objView.Columns
           if(Instr(1,ignoreCols,"[" &objView.ColumnName(cols) & "]",1) = 0) then
            columns = columns & objView.ColumnName(cols) & " = [" & objView.ColumnName(cols) & "] ,"           
           end if
        Next 
        columns= mid(columns,1,len(columns)-1)     
     end if
     
GetColumns = columns & values
end function

'gets the table name from the query
public function GetTableName(byval query)

    dim pos, endPos1, endPos2, tblName, segment
    pos = inStr(1,query,QUERY_FROM,1)
    if (pos > 0) then
        pos = pos + len(QUERY_FROM)
        segment = ltrim(mid(query,pos))
        endPos1 = inStr(1,segment," ",1)
        endPos2 = inStr(1,segment,"(",1)
        if(endPos2 < endPos1) then endPos1 =endPos2
        
        tblName = Mid(segment,1,endPos1-1)    
    end if
  
GetTableName = tblName
end function

'gets the where clause from the query
public function GetWhereClause(byval key, byval value)

    dim segment   
    segment = QUERY_WHERE & " " & key & " = " & value
  
GetWhereClause = segment
end function

'writes the query to a text file
public function WriteToFile(fileName,text )

    Dim fileStream, objFSO
    
    Set objFSO = CreateObject("Scripting.FileSystemObject")
    set fileStream = objFSO.OpenTextFile(fileName, 8, True)

    fileStream.WriteLine(text)
    fileStream.Close

    set fileStream = NOTHING
    set objFSO = NOTHING

WriteToFile = true
end function

'gets the columns to ignore i.e. primary key, timestamp
public function GetColsToIgnore(byval tblName, byref pKey)

dim objTable, keys, objCol, key
set objTable = objDb.tables(tblName)
  
  For key = 1 To objTable.Columns.Count
    set objCol = objTable.Columns(key)
    if (objCol.Identity or objCol.InPrimaryKey or objCol.IsComputed or objCol.Datatype = "timestamp") then    
        keys = keys & "[" & objCol.Name & "],"
    end if
    
    'get the identity 
    if (objCol.Identity) then
        pKey = objCol.Name
    end if
        
  Next
 
   keys = Mid(keys,1,len(keys)-1) 
 
GetColsToIgnore = keys
end function