/************************************************
GEO Database Sample

Purpose: Shows how to associate an IP address to a geographical location

Created: 0garcia 06102009

Disclaimer:
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
WITH NO WARRANTIES. THIS SOFTWARE IS PROVIDED AS DEMO ONLY. 
YOU CAN MODIFY AND USE AT YOUR OWN RISK.
************************************************/
Print 'THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
WITH NO WARRANTIES. THIS SOFTWARE IS PROVIDED AS DEMO ONLY. 
YOU CAN MODIFY AND USE AT YOUR OWN RISK.' 
Print '************************************************'
/************************************************
Name: [ConvertIp2Num]

Purpose: converts an ip address to a number

Created: 0garcia 06102009
************************************************/

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ConvertIp2Num]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[ConvertIp2Num]
GO

PRINT 'Creating function ConvertIp2Num'
GO

CREATE function dbo.ConvertIp2Num(@ip nvarchar(15))
returns bigint
as
begin

	declare @delimiter NVARCHAR(1), @SUBNET_MASK INT

	set @delimiter = '.'
	set @SUBNET_MASK = 256

    DECLARE @textXML XML;
    SELECT    @textXML = CAST('<col>' + REPLACE(@ip, @delimiter, '</col><col>') + '</col>' AS XML);

	DECLARE @idx int, @ipNum float
	SET @idx = 4
	SET @ipNum = 0

	declare @segments table(id int ,col int)
    INSERT INTO @segments(id, col)    
		--reorder the sections. must start from the right segment (4 to 1)
		SELECT  ROW_NUMBER () OVER (ORDER BY col) as id, 
				T.col.value('.', 'int') as col				
		FROM    @textXML.nodes('/col') T(col)
		order by id desc
    
	--convert segments to number
	select  @ipNum = @ipNum + (cast((col % @SUBNET_MASK) as float) * power(@SUBNET_MASK,@idx-id))
	from @segments

	return cast(@ipNum as bigint)
end

GO


/************************************************
Name: [ConvertNum2Ip]

Purpose: converts a number to an ip address format

Created: 0garcia 06102009

************************************************/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ConvertNum2Ip]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[ConvertNum2Ip]
GO

PRINT 'Creating function ConvertNum2Ip'
GO

create function dbo.ConvertNum2Ip(@ip bigint)
returns nvarchar(15)
as
begin

	declare @delimiter NVARCHAR(1), @SUBNET_MASK INT
	set @delimiter = '.'
	set @SUBNET_MASK = 256
    

	DECLARE @idx int, @ipSeg bigint
	SET @idx = 1
	SET @ipSeg = 0

	declare @segments nvarchar(15) 
	set @segments = ''
	while (@idx <= 4)
    begin		
		--get the segments. must start from the left segment (1 to 4)
		set @ipSeg = cast(@ip / power(@SUBNET_MASK,4-@idx) as bigint)
		set @ip=@ip - cast(@ipSeg * power(@SUBNET_MASK,4-@idx) as bigint)		

		--build the string
		if (@idx = 1)
			set @segments = cast(@ipSeg as varchar)
		else
			set @segments = @segments + @delimiter + cast(@ipSeg as varchar)

		set @idx = @idx +1
	end
    
	return  @segments	
end

GO

/************************************************
Name: [GeoLiteCity_Blocks]

Purpose: holds the ip range association to a location

Created: 0garcia 06102009

************************************************/

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GeoLiteCity_Blocks]') AND type in (N'U'))
DROP TABLE [dbo].[GeoLiteCity_Blocks]
GO

PRINT 'Creating  table [GeoLiteCity_Blocks]' 
GO

CREATE TABLE [dbo].[GeoLiteCity_Blocks](
	[startIpNum] [bigint] NOT NULL,
	[endIpNum] [bigint] NOT NULL,
	[locId] [int] NOT NULL,
 CONSTRAINT [PK_GeoBlocks] PRIMARY KEY CLUSTERED 
(
	[startIpNum] ASC,
	[endIpNum] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO


/************************************************
Name: [GeoLiteCity_Location]

Purpose: provides the location data

Created: 0garcia 06102009

************************************************/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GeoLiteCity_Location]') AND type in (N'U'))
DROP TABLE [dbo].[GeoLiteCity_Location]
GO

PRINT 'Creating  table [GeoLiteCity_Location]' 
GO

CREATE TABLE [dbo].[GeoLiteCity_Location](
	[locId] [int] NOT NULL,
	[country] [nvarchar](5) NULL,
	[region] [nvarchar](55) NULL,
	[city] [nvarchar](55) NULL,
	[postalCode] [nvarchar](10) NULL,
	[latitude] [decimal](8, 5) NULL,
	[longitude] [decimal](8, 5) NULL,
	[metroCode] [nvarchar](5) NULL,
	[areaCode] [nvarchar](5) NULL,
 CONSTRAINT [PK_GeoLocation] PRIMARY KEY CLUSTERED 
(
	[locId] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]


GO

Print '************************************************'
Print 'GEO Demo objects were created'