USE [DBCopy]
GO

if exists(select * from sys.objects where type = 'P' and name = 'usp_PYRefreshSelect')
begin
	DROP PROCEDURE [dbo].[usp_PYRefreshSelect]
end
GO


/****** Object:  StoredProcedure [dbo].[usp_PYRefreshSelect]    Script Date: 4/17/2019 11:02:25 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


-- =============================================
-- Author:		Ben Kubicek
-- Create date: 5/24/2016
-- Description:	Select any active records in CopyParams This is used by the website to display available databases to refresh in the grid
-- <# v1.0.1 #> 5/24/2016 created
-- =============================================
CREATE PROCEDURE [dbo].[usp_PYRefreshSelect]
AS
BEGIN

        SET NOCOUNT ON;
		SELECT CopyParamsID, DBName, WrittenDate, ProcessTime, NeedProcess, Abort, Error, ErrorMessage 
		FROM dbo.CopyParams 
		WHERE active = 1
		ORDER BY DBName
END

GO


