USE [DBCopy]
GO
if exists(select * from sys.objects where type = 'P' and name = 'usp_ProcessPYRefresh')
begin
	DROP PROCEDURE [dbo].[usp_ProcessPYRefresh]
end
GO


/****** Object:  StoredProcedure [dbo].[usp_ProcessPYRefresh]    Script Date: 4/17/2019 10:58:54 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


-- =============================================
-- Author:		Ben Kubicek
-- Create date: 5/24/2016
-- Description:	Processes any records in CopyParams that need to refreshed
-- <# v1.0.1 #> 5/24/2016 created ~
-- =============================================
CREATE PROCEDURE [dbo].[usp_ProcessPYRefresh]
(@showOutput BIT = 0)
AS
BEGIN

        SET NOCOUNT ON;
		declare @now datetime,
		@copyParamsID bigint,
		@restoreScript nvarchar(max),
		@simpleScript nvarchar(200),
		@ret int,
		@BackupLocation varchar(500),
		@BackupLocationFile varchar(500),
		@PlantName varchar(50),
		@DBName varchar(100),
		@emailSubject varchar(500),
		@emailBody varchar(500)

		--This temp table is used to hold the results of the call to xp_dirtree to see the list of backup files.
		create table #backups (id int identity(1,1), subdirectory nvarchar(500), depth int, [file] int)

		set @now = getdate()

		--See if there is a database that need to be restored
		select top 1 @copyParamsID = CopyParamsID from DBCopy.dbo.copyParams where NeedProcess = 1 and Abort = 0 and ProcessTime <= @now
		WHILE @copyParamsID IS NOT NULL
		BEGIN
			--We have to query the actual file name because it is dynamic
			--delete any previous backup file info
			delete from #backups

			--Select some data from the database we will restore
			select @BackupLocation = backuplocation,
			@DBName = DBName,
			@PlantName = PlantName from DBCopy.dbo.copyParams where CopyParamsID = @copyParamsID

			--Query the backup folder location to get the backup folder names
			insert into #backups
			exec master.sys.xp_dirtree @backuplocation,0,1

			set @backupLocationFile = ''
			--There can be multiple backup files to just try to grab the most recent one
			select top 1 @backuplocationfile ='\'+subdirectory from #backups order by id desc

			IF @backuplocationfile <> ''
			BEGIN
				--first close all the connections
				exec master.dbo.usp_killConnections @DBName
		
				--script the restore based off database info
				select @restoreScript = 'RESTORE DATABASE ' +DBName+
				' from disk = '''+@backuplocation+@backuplocationfile+'''
				with Recovery, replace,
				  move '''+datafilename+''' TO '''+DataFilePath+''',
				  move '''+logfilename+''' TO '''+logfilepath+'''',
				  @simpleScript = 'Alter Database '+DBName+' SET RECOVERY SIMPLE' from DBCopy.dbo.copyParams where CopyParamsID = @copyParamsID

				  if @showoutput = 1
				  begin --for debugging
					select @restoreScript
				  end

				  --If we get an error then save error to record
				  BEGIN TRY
					--This is where the restore script gets executed
					EXECUTE @ret = sp_executesql @restoreScript
				  END TRY
				  BEGIN CATCH
					--There was an error so mark the restore as such
					UPDATE dbo.CopyParams SET WrittenDate = @now, NeedProcess = 0, Error=1, ErrorMessage= ERROR_MESSAGE() WHERE CopyParamsID = @copyParamsID
					SELECT ERROR_MESSAGE()
					SET @emailsubject = 'Test Refresh at '+@PlantName + ' for database '+@DBName+' FAILED!  Please investigate.'

					EXEC msdb.dbo.sp_send_dbmail @recipients="DBA@YourCompany.com", @subject=@emailsubject, @body=@emailbody
					SET @ret = 1
				  END CATCH

				IF @ret = 0
				BEGIN --restored must have worked so now set record as done and try to put database into simple mode
					UPDATE dbo.CopyParams SET WrittenDate = @now, NeedProcess = 0, Error=0, ErrorMessage = NULL WHERE CopyParamsID = @copyParamsID
					EXECUTE @ret = sp_executesql @simpleScript
					--Send out success email
					SET @emailsubject = 'Test Refresh at '+@PlantName + ' for database '+@DBName+' was restored successfully.'
					SET @emailBody = 'Test Refresh at '+@PlantName + ' for database '+@DBName+' was restored successfully.'
					EXEC msdb.dbo.sp_send_dbmail @recipients="DevGroupEmail@YourCompany.com", @subject=@emailsubject, @body=@emailbody
					
					
				END
				ELSE BEGIN
					UPDATE dbo.CopyParams SET WrittenDate = @now, NeedProcess = 0, Error=1 WHERE CopyParamsID = @copyParamsID
				END
			END
			ELSE BEGIN
				--No backup file found
				SET @emailsubject = 'Test Refresh at '+@PlantName + ' for database '+@DBName+' FAILED!  No backup file found.'

				EXEC msdb.dbo.sp_send_dbmail @recipients="DBA@YourCompany.com", @subject=@emailsubject, @body=@emailbody

				UPDATE dbo.CopyParams SET WrittenDate = @now, NeedProcess = 0, Error=1, ErrorMessage= 'No backup file found.' WHERE CopyParamsID = @copyParamsID
			END

			--reset
			SET @copyParamsID = NULL
			--Find next record
			SELECT TOP 1 @copyParamsID = CopyParamsID FROM DBCopy.dbo.copyParams WHERE NeedProcess = 1 AND Abort = 0 AND ProcessTime <= @now
		END --while

		DROP TABLE #backups
END

GO


