USE [DBCopy]
GO

if exists(select * from sys.objects where type = 'P' and name = 'usp_PYRefreshUpdate')
begin
	DROP PROCEDURE [dbo].[usp_PYRefreshUpdate]
end
GO

/****** Object:  StoredProcedure [dbo].[usp_PYRefreshUpdate]    Script Date: 4/17/2019 11:03:56 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


-- =============================================
-- Author:		Ben Kubicek
-- Create date: 5/24/2016
-- Description:	Update CopyParams record based off input via website
-- <# v1.0.1 #> 5/24/2016 created ~
-- <# v1.0.2 #> 6/1/2016 bsk added timezone ~
-- <# v1.0.3 #> 6/1/2016 bsk added cancelled email ~
-- <# v1.0.4 #> 6/21/2016 bsk added @userName parameter
-- =============================================
CREATE PROCEDURE [dbo].[usp_PYRefreshUpdate]
(
	@CopyParamsID BIGINT,
	@NeedProcess BIT,
	@userName VARCHAR(100) = NULL
)
AS
BEGIN

        SET NOCOUNT ON;
		declare @now datetime,
		@processTime datetime
		set @now = getdate()
		--Add 30 minutes to time change this here if you want longer or shorter time before refresh
		select @processTime = dateadd(minute,30,@now)
		
		Update dbo.CopyParams set NeedProcess = @NeedProcess, WrittenDate = @now, processTime = @processtime
		where CopyParamsID = @CopyParamsID 

		DECLARE @PlantName VARCHAR(50),
		@DBName VARCHAR(100),
		@emailSubject VARCHAR(500),
		@emailBody VARCHAR(500)
		SELECT @DBName = DBName,
		@PlantName = PlantName FROM DBCopy.dbo.copyParams WHERE CopyParamsID = @copyParamsID

		IF @needProcess = 1
		BEGIN
			UPDATE dbo.CopyParams SET CreateUser = @username, UpdateUser = NULL WHERE CopyParamsID = @CopyParamsID 
			--Get timezone So the email displays the timezone used for the time of the refresh
			
			DECLARE @TimeZone VARCHAR(50)
			BEGIN TRY
				EXEC MASTER.dbo.xp_regread 'HKEY_LOCAL_MACHINE',
				'SYSTEM\CurrentControlSet\Control\TimeZoneInformation',
				'TimeZoneKeyName',@TimeZone OUT
			--SELECT @TimeZone
			END TRY
			BEGIN CATCH
			END CATCH

			SELECT @TimeZone = REPLACE(@TimeZone,'Standard ','')

			-- Going to do a refresh so let people know.
			SET @emailsubject = 'Test Refresh at '+@PlantName + ' for database '+@DBName+' will be restored on '+CONVERT(VARCHAR(20),@processTime)+' ('+@TimeZone+')'
			SET @emailBody = 'Test Refresh at '+@PlantName + ' for database '+@DBName+' will be restored on '+CONVERT(VARCHAR(20),@processTime)+' ('+@TimeZone+')'+'  Please save any work before that time.'
			IF @username IS NOT NULL
			BEGIN
				SET @emailbody = @emailbody+' This refresh was requested by: '+@userName 
			END
			
		END
		ELSE BEGIN
			UPDATE dbo.CopyParams SET UpdateUser = @username WHERE CopyParamsID = @CopyParamsID 

			SET @emailsubject = 'Test Refresh at '+@PlantName + ' for database '+@DBName+' was CANCELLED!'
			SET @emailBody = 'Test Refresh at '+@PlantName + ' for database '+@DBName+' was CANCELLED!  The refresh was cancelled.'
			IF @username IS NOT NULL
			BEGIN
				SET @emailbody = @emailbody+' This refresh was cancelled by: '+@userName 
			END
		END

		EXEC msdb.dbo.sp_send_dbmail @recipients="DevGroupEmail@YourCompany.com", @subject=@emailsubject, @body=@emailbody
			
END

GO


