USE [master]
GO

if exists(select * from sys.objects where type = 'P' and name = 'usp_KillConnections')
begin
	DROP PROCEDURE [dbo].[usp_KillConnections]
end
GO

/****** Object:  StoredProcedure [dbo].[usp_KillConnections]    Script Date: 4/17/2019 11:12:07 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO



-- =============================================
-- Author:		Ben Kubicek
-- Create date: 5/25/2016
-- Description:	This stored proc will kill all connections to the database passed in
-- <# v1.0.1 #> 5/25/2016 created ~
-- <# v1.0.2 #> 5/31/2016 bsk fixed select so all connection are killed not just first one. ~
-- <# v1.0.3 #> 6/1/2016 bsk switched to top 1 in select ~
-- =============================================
CREATE PROCEDURE [dbo].[usp_KillConnections]
(@dbname sysname)
AS
BEGIN

	DECLARE @spid INT
	SELECT TOP 1 @spid = spid FROM master.dbo.sysprocesses
	WHERE dbid = DB_ID(@dbname)
	WHILE @spid IS NOT NULL
	BEGIN
			EXECUTE ('Kill ' + @spid)
			SET @spid = NULL
			SELECT TOP 1 @spid = spid FROM master.dbo.sysprocesses
			WHERE dbid = DB_ID(@dbname) 
	END

END

GO


