
CREATE TABLE [dbo].[C_B_PARTY_RLE_COUNT_CUAM](
	[ROWID_OBJECT] [nchar](14) NOT NULL,
	[CREATOR] [nvarchar](50) NULL,
	[CREATE_DATE] [datetime2](7) NULL,
	[UPDATED_BY] [nvarchar](50) NULL,
	[LAST_UPDATE_DATE] [datetime2](7) NULL,
	[CONSOLIDATION_IND] [bigint] NOT NULL,
	[DELETED_IND] [bigint] NULL,
	[DELETED_BY] [nvarchar](50) NULL,
	[DELETED_DATE] [datetime2](7) NULL,
	[LAST_ROWID_SYSTEM] [nchar](14) NOT NULL,
	[DIRTY_IND] [bigint] NULL,
	[INTERACTION_ID] [bigint] NULL,
	[HUB_STATE_IND] [bigint] NOT NULL,
	[CM_DIRTY_IND] [bigint] NULL,
	[PARTY_ID] [nchar](14) NULL,
	[CONTACT_ROLE] [nvarchar](500) NULL,
	[CURRENT_ALLOCATION] [bigint] NULL,
	[CMID] [nchar](14) NULL,
 CONSTRAINT [SVR1_18OKTB5] PRIMARY KEY CLUSTERED 
(
	[ROWID_OBJECT] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [CMX_DATA]
) ON [CMX_DATA]
GO

ALTER TABLE [dbo].[C_B_PARTY_RLE_COUNT_CUAM] ADD  CONSTRAINT [DF_C_B_PARTY_RLE_COUNT_CUAM_CREATOR]  DEFAULT ('CMX') FOR [CREATOR]
GO

ALTER TABLE [dbo].[C_B_PARTY_RLE_COUNT_CUAM] ADD  CONSTRAINT [DF_C_B_PARTY_RLE_COUNT_CUAM_CREATE_DATE]  DEFAULT (getdate()) FOR [CREATE_DATE]
GO

ALTER TABLE [dbo].[C_B_PARTY_RLE_COUNT_CUAM] ADD  CONSTRAINT [DF_C_B_PARTY_RLE_COUNT_CUAM_CONSOLIDATION_IND]  DEFAULT ((4)) FOR [CONSOLIDATION_IND]
GO

ALTER TABLE [dbo].[C_B_PARTY_RLE_COUNT_CUAM] ADD  CONSTRAINT [DF_C_B_PARTY_RLE_COUNT_CUAM_HUB_STATE_IND]  DEFAULT ((1)) FOR [HUB_STATE_IND]
GO

--------------------------------------------
-- indexes 


ALTER TABLE [dbo].[C_B_PARTY_RLE_COUNT_CUAM] ADD  CONSTRAINT [SVR1_18OKTB5] PRIMARY KEY CLUSTERED 
(
	[ROWID_OBJECT] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [CMX_DATA]
GO



CREATE NONCLUSTERED INDEX [SVR1_18OKTB6] ON [dbo].[C_B_PARTY_RLE_COUNT_CUAM]
(
	[CONSOLIDATION_IND] ASC,
	[ROWID_OBJECT] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [CMX_INDX]
GO


CREATE NONCLUSTERED INDEX [SVR1_18OKTOG] ON [dbo].[C_B_PARTY_RLE_COUNT_CUAM]
(
	[PARTY_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [CMX_INDX]
GO


CREATE NONCLUSTERED INDEX [SVR1_18OKTOK] ON [dbo].[C_B_PARTY_RLE_COUNT_CUAM]
(
	[CONTACT_ROLE] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [CMX_INDX]
GO


----------------------------------------------
--question: sort in tempdb must be option or sorting in user db is a good option
----------------------------------------------
--row count 
select count(*) from [dbo].[C_B_PARTY_RLE_COUNT_CUAM];
--115825
--number system

----------------------------------------------